//
//  MCPGServer+Environment.h
//  MCClientServer
//
//  Created by Brent Gulanowski on 10-04-05.
//  Copyright 2010 Marketcircle Inc. All rights reserved.
//

#import "MCDaemonKeeper.h"

#import <MCPostgresPersistence/MCPGServer.h>
#import <MCFoundation/MCPUserProtocol.h>


// The following must be implemented by App-specific subclasses of MCPGServer to support sync
@interface MCPGServer (MCSSubclassEnvironment)

@property (retain) MCDaemonKeeper *daemonKeeper;

- (NSArray *)replicaNames;
- (NSString *)replicaNameForDatabaseName:(NSString *)dbName;
- (BOOL)createReplicaFromMaster:(MCPGDatabase*)aMaster progressDelegate:(id)progressDelegate error:(NSError**)error;

- (NSString *)databaseInUseLockPath;
- (unsigned)accessdPort;
- (unsigned)touchdPort;
- (NSString *)databaseURLScheme;
- (unsigned)pkeyOffsetIncrement;
- (unsigned)schemaVersion;
- (NSString *)touchDatabaseName;
- (BOOL)hideInactiveClients;
- (void)setHideInactiveClients:(BOOL)flag;
- (BOOL)touchWasTurnedOn;
- (void)setTouchWasTurnedOn:(BOOL)flag;
- (BOOL)userIsRestrictedForTouchSync:(id<MCPUserProtocol>)user;

- (NSString *)rootStageDirectoryPath;

@end


@interface MCPGServer (MCSEnvironmentIdentifier)

/*
 * The offline environment identifier is dynamically generated from the machine identifier
 * (the dotted concatenation of the serial number or the primary MAC address with the Mac OS X username);
 * the oeid is cached as the poeid (previous oeid) if it has changed.
 * Each time a client syncs, it compares the oeid and poeid; if they have changed, it takes one of three
 * possible actions; the action taken depends on the client/server offline major sync state comparison:
 * 1. if the offline sync state matches, the client stores the date that the oeid change was detected
 * 2. if the server's last sync date is newer, the client changes its offline uuid and changes its
 *    primary key offset, and updates its last sync date to match the stored date the oeid was discovered
 *    to have changed (as stored by the other copy)
 * 3. if the server's last sync date is older, the offline is declared invalid and put into recovery mode
 */
- (NSString *)environmentIdentifier;
- (NSString *)oldEnvironmentIdentifier;
- (BOOL)environmentIdentifierChanged;
- (void)updateEnvironmentIdentifier;

@end
